IF OBJECT_ID('TELE_ORC_EST_PROD_TRANSF') IS NULL
begin
CREATE TABLE [dbo].[TELE_ORC_EST_PROD_TRANSF](
	[CD_ORC] [int] NOT NULL,
	[CD_EMP] [int] NOT NULL,
	[CD_FILIAL] [int] NOT NULL,
	[CD_CTR] [int] NOT NULL,
	[DT_CAD] [datetime] NOT NULL,
	[CD_USU] [int] NOT NULL,
 CONSTRAINT [PK_TELE_ORC_EST_PROD_TRANSF] PRIMARY KEY CLUSTERED 
(
	[CD_ORC] ASC,
	[CD_EMP] ASC,
	[CD_FILIAL] ASC,
	[CD_CTR] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY],
 CONSTRAINT [IX_TELE_ORC_EST_PROD_TRANSF] UNIQUE NONCLUSTERED 
(
	[CD_ORC] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY],
 CONSTRAINT [IX_TELE_ORC_EST_PROD_TRANSF_1] UNIQUE NONCLUSTERED 
(
	[CD_ORC] ASC,
	[CD_FILIAL] ASC,
	[CD_EMP] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]


ALTER TABLE [dbo].[TELE_ORC_EST_PROD_TRANSF] ADD  CONSTRAINT [DF_TELE_ORC_EST_PROD_TRANSF_CD_ORC]  DEFAULT ((0)) FOR [CD_ORC]

ALTER TABLE [dbo].[TELE_ORC_EST_PROD_TRANSF] ADD  CONSTRAINT [DF_TELE_ORC_EST_PROD_TRANSF_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

ALTER TABLE [dbo].[TELE_ORC_EST_PROD_TRANSF] ADD  CONSTRAINT [DF_TELE_ORC_EST_PROD_TRANSF_CD_FILIAL]  DEFAULT ((0)) FOR [CD_FILIAL]

ALTER TABLE [dbo].[TELE_ORC_EST_PROD_TRANSF] ADD  CONSTRAINT [DF_TELE_ORC_EST_PROD_TRANSF_CD_CTR]  DEFAULT ((0)) FOR [CD_CTR]

ALTER TABLE [dbo].[TELE_ORC_EST_PROD_TRANSF] ADD  CONSTRAINT [DF_TELE_ORC_EST_PROD_TRANSF_DT_CAD]  DEFAULT (getdate()) FOR [DT_CAD]

ALTER TABLE [dbo].[TELE_ORC_EST_PROD_TRANSF] ADD  CONSTRAINT [DF_TELE_ORC_EST_PROD_TRANSF_CD_USU]  DEFAULT ((0)) FOR [CD_USU]

ALTER TABLE [dbo].[TELE_ORC_EST_PROD_TRANSF]  WITH CHECK ADD  CONSTRAINT [FK_TELE_ORC_EST_PROD_TRANSF_EST_PROD_TRANSF] FOREIGN KEY([CD_EMP], [CD_FILIAL], [CD_CTR])
REFERENCES [dbo].[EST_PROD_TRANSF] ([CD_EMP], [CD_FILIAL], [CD_CTR])

ALTER TABLE [dbo].[TELE_ORC_EST_PROD_TRANSF] CHECK CONSTRAINT [FK_TELE_ORC_EST_PROD_TRANSF_EST_PROD_TRANSF]

ALTER TABLE [dbo].[TELE_ORC_EST_PROD_TRANSF]  WITH CHECK ADD  CONSTRAINT [FK_TELE_ORC_EST_PROD_TRANSF_TELE_ORC] FOREIGN KEY([CD_ORC])
REFERENCES [dbo].[TELE_ORC] ([CD_ORC])

ALTER TABLE [dbo].[TELE_ORC_EST_PROD_TRANSF] CHECK CONSTRAINT [FK_TELE_ORC_EST_PROD_TRANSF_TELE_ORC]
end